/***************************************************************
AboutDialog.cpp : implementation file

	Author:	John Wyatt

  Module to create a CAboutDialog object for displaying version 
  information about a file. The dialog box has an appearance
  similar to the Win 95 file properties tab.
  Alternately, the version number can be returned as a string.
  
  The object constructor is:

	CAboutDialog dlg(LPCTSTR szFileName = NULL, LPCTSTR szTitle = NULL, CWnd* pParent = NULL)
			Reads version information about szFileName. If szFileName is NULL,
			it reads version information about the module that created
			this object.

			szTitle is the caption to display in the dialog box,
			such as "About this program".
			if szTitle is NULL (the default value), the caption reads:
			"About <filename>"

			pParent is the parent window for the dialog box.

	To display the version information:
			dlg.DoModal();

	To get only the version and product information as a CString, call:
			dlg.GetVersion();
			dlg.GetProduct();

  TO USE THIS MODULE:
	ADD RESOURCE
		Add the IDD_ABOUT_DIALOG resource OR
		if using the component AboutDialog.ogx, add the
		component to the project.

	INCLUDE:
		"AboutDialog.h"
		"<your project's main header file>" to get the resource ID's

	LINK:
		version.lib
***************************************************************/

#include "stdafx.h"
#include "resource.h"			// Main project header points to resource ID's
#include "AboutDialog.h"

#include <winver.h>
#include <windowsx.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//---------------------------------------------------------------------------
//	VERSION INFO TEXT:
#define SZABOUT			"About "
#define SZLANGUAGE		"Language"
#define SZCOMPANY		"CompanyName"
#define SZPRODUCTNAME	"ProductName"
#define SZPRODUCTVER	"ProductVersion"
#define SZLEGAL			"LegalTrademarks"
#define SZINTERNAL		"InternalName"
#define SZORIGINAL		"OriginalFilename"
#define SZCOMMENTS		"Comments"

#define SZPRIVATE		"PrivateBuild"
#define SZSPECIAL		"SpecialBuild"
#define SZPRERELEASE	"Pre-Release version"
#define SZDEBUGVER		"DEBUG VERSION"

#define SZFILEVERSION	"FileVersion"
#define SZFILEDESC		"FileDescription"
#define SZLEGALCOPY		"LegalCopyright"
#define SZNONE			"[none]"

/////////////////////////////////////////////////////////////////////////////
// CAboutDialog dialog constructor

CAboutDialog::CAboutDialog(LPCTSTR szFile, LPCTSTR szTitle /*=NULL*/, CWnd* pParent /*=NULL*/)
	: CDialog(CAboutDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAboutDialog)
	m_Copyright = _T("");
	m_Description = _T("");
	m_Version = _T("");
	m_VersionOutputBox = _T("");
	m_PreRelease = _T("");
	m_Debug = _T("");
	//}}AFX_DATA_INIT

	TCHAR*	lpFileName;			// Pointer to file name without path

	// Init variables
	m_abData = NULL;
	m_dwFlags = 0l;
	m_vsInfo = NULL;
	m_bHasVerInfo = FALSE;
	_tcscpy(m_szWindowText, _T("") );
	_tcscpy(m_szVersion, _T(""));


	// Was a filename passed in?
	if (szFile)
	{	// Yes, copy it to the local variable
		_tcscpy( m_szFileName, szFile);
	}
	else
	{	// No. Get my module handle and filename
		::GetModuleFileName(GetModuleHandle(NULL), m_szFileName, sizeof(m_szFileName));
	}

	// Make a pointer to the filename only (without the path) for
	// the default window title.
	int iSize = _tcsclen(m_szFileName);

	// Make a pointer to scan the string with
	lpFileName = m_szFileName;

	// If the string has characters,
	// scan the string backwards for the last occurence of '\'
	if (iSize > 0)
	{
		// Go to the last backslash in the string and point just past it;
		// or use whole string if there is no backslash.
		lpFileName = _tcsrchr(m_szFileName, _T('\\'));
		if (lpFileName == NULL)
			lpFileName = m_szFileName;
		else
			lpFileName = _tcsinc(lpFileName);
	}

	// Create the file name to display in the dialog title box.
	// Use the filename as a default if no title was passed in.
	if (szTitle)
	{
		_tcscpy(m_szWindowText, _T(SZABOUT) );
		_tcscat(m_szWindowText, szTitle);
	}
	else
	{
		_tcscpy(m_szWindowText, _T(SZABOUT) );
		_tcscat(m_szWindowText, lpFileName);
	}

} // End CAboutDialog::CAboutDialog(...) constructor

/////////////////////////////////////////////////////////////////////////////
// CAboutDialog dialog destructor
CAboutDialog::~CAboutDialog()
{
	// Free memory if needed
	if (NULL != m_abData) 
	{
		GlobalFreePtr(m_abData);
	}

} // End CAboutDialog::~CAboutDialog() destructor

/////////////////////////////////////////////////////////////////////////////
void CAboutDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDialog)
	DDX_Control(pDX, IDC_VERINFO_LIST, m_VersionInfoList);
	DDX_Text(pDX, IDC_COPYRIGHT_STATIC, m_Copyright);
	DDX_Text(pDX, IDC_DESCRIPTION_STATIC, m_Description);
	DDX_Text(pDX, IDC_VERSION_STATIC, m_Version);
	DDX_Text(pDX, IDC_OUTPUT_EDIT, m_VersionOutputBox);
	DDX_Text(pDX, IDC_PRERELEASE_STATIC, m_PreRelease);
	DDX_Text(pDX, IDC_DEBUG_STATIC, m_Debug);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAboutDialog, CDialog)
	//{{AFX_MSG_MAP(CAboutDialog)
	ON_LBN_SELCHANGE(IDC_VERINFO_LIST, OnSelchangeVerinfoList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAboutDialog message handlers

BOOL CAboutDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();

	// Load the listbox.
	// IMPORTANT NOTE:
	// Language MUST be the first item in the listbox,
	// and the listbox not sorted. Language is the only
	// resource in the listbox that does not appear as a string
	// in the versioninfo block. Instead it's a DWORD and must
	// be passed to a translation function. Rather than search
	// the listbox for the location of "Language", I chose to
	// put Language first, so I will always know which listbox item
	// needs to be translated.
	m_VersionInfoList.AddString(SZLANGUAGE);
	m_VersionInfoList.AddString(SZCOMPANY);
	m_VersionInfoList.AddString(SZPRODUCTNAME);
	m_VersionInfoList.AddString(SZPRODUCTVER);
	m_VersionInfoList.AddString(SZLEGAL);
	m_VersionInfoList.AddString(SZINTERNAL);
	m_VersionInfoList.AddString(SZORIGINAL);
	m_VersionInfoList.AddString(SZCOMMENTS);

	// Read the versioninfo block and load the listbox data items
	// with pointers to the string data. In the case of Language,
	// a pointer to the class variable m_szLanguage will be entered.

	if (!m_bHasVerInfo) {
		m_bHasVerInfo = GetVersionInfo();
	}

	// Set the window title
	SetWindowText(m_szWindowText);

	// The dialog box static text will be updated. The
	// other version info will be pulled from the block when the
	// item is selected in the listbox.
	UpdateData(FALSE);

	// Fill the list box with the version strings
	FillListBox();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} // End CAboutDialog::OnInitDialog()

/*--------------------------------------------------------------
BOOL GetVersionInfo()
	Read the version info and update the class variables.
	A block of memory will be allocated to hold the version info.

Returns:	TRUE if version info was read OK. The class variables
			will hold the version information, except for those
			items that are displayed in the list box, which get
			retrieved when the list box item is clicked.

			Sets m_szWindowText to a string that can be displayed as the
			dialog box window text. The string is "About <file name>"

	If the build flags include VS_FF_PRIVATEBUILD or VS_FF_SPECIALBUILD,
	the listbox will have these items added to it.

	FUNCTION DESCRIPTION:
	Getting the resource information is not a simple task. The VERSIONINFO
	block is laid out as follows:
		FIXED LENTH DATA
		VARIABLE LENGTH STRING DATA (by translation)
		TRANSLATION DATA

	For more information see the Microsoft Programmers Reference, Volume 4
	under the VERSIONINFO resource description and Volume 3 under the
	VS_FIXEDFILEINFO structure.

	Information such as file version, name, copyright and comments is in
	the Variable length string block. This string block is identified by
	translation, so we must first know the translation information.
	Build flags are contained in the fixed length data block.

	The process for retrieving version info is not obvious, so the process
	is described here:

	1)	Get the name of the file. Version info is read directly from a file
		because the original intention of version info was to prevent overwriting
		new files with older versions, so applications have to be able to read
		another files' version info while that file is still closed.
		Thus version info is read by filename, instead of by instance handle.

	2)	Get the size (in bytes) of the version resource. This is required since the
		version resource has variable length string data. Allocate memory
		to hold the version information.

	3)	Read the version info into a data buffer. The version info is not just string
		data, but mixed binary and text. For this reason one must use the provided
		API calls to query the version info in the buffer.
		At this time the fixed version info can be read from the root block "\\".
		This is where we read the fixed version info for the build flags.
		For additional information see the Microsoft Windows Programming Reference
		volume 3 for the VS_FIXEDFILEINFO struct definition.

	4)	Get the translation info. The version resource contains binary codes for the
		language and character set. This allows international versions to be built
		and installed properly. The translation info is contained in two unsigned ints.
		Example: the code for US English is 0x0409. The code for the Windows
		Multi-lingual character set is 1252 (0x04E4). The translation string (in ACSII)
		would be "040904E4". This is the default translation for the U.S.

	5)	Query the version data that was read into the buffer for each desired piece
		of information. The string data that we will be reading here is organized
		in blocks by translation.
		A typical query for string info would be:
		"\\StringFileInfo\\<language code in ASCII>\\<string type>"

    6)	Version information is put into the dialog box. 
		Once the object is destroyed, release memory that was allocated earlier.
--------------------------------------------------------------*/
BOOL CAboutDialog::GetVersionInfo()
{
	DWORD  	dwhandle;			// Needed for back compatibility
	DWORD  	dwSize;				// Size of version info
	UINT	uSize;				// Size of the retrieved version resource
	LPBYTE 	lpBuffer;			// Pointer to version data strings
	char	szQuery[50];		// Contains the version query string
	BOOL	bSuccess = FALSE;	// Return value

	// Have we already done this?
	if (m_bHasVerInfo) {
		return TRUE;
	}

	// Free memory if needed. This could happen if the file
	// had an inferred version info block, and this function
	// was called more than once before this object was destroyed.
	if (NULL != m_abData) {
		GlobalFreePtr(m_abData);
	}

	// Get the size (in bytes) of the version info block.
	// As a note, the dwHandle variable will get set to zero, though it
	// isn't used for anything since Windows 3.0
	dwSize = ::GetFileVersionInfoSize((LPSTR)m_szFileName, &dwhandle);

	// If there is version info, allocate memory for the version info block
	if (dwSize > 0)
		m_abData = GlobalAllocPtr(GMEM_MOVEABLE, dwSize);

	// Was memory allocated for the version info block?
	if (m_abData)
	{
		// The file has version info. Now read it into the m_abData buffer.
		// Note that although dwHandle must be passed, it is ignored by Windows.
		::GetFileVersionInfo((LPSTR)m_szFileName, dwhandle, dwSize, m_abData);

		// Now we have the version info in the m_abData buffer.
		// Read the fixed version info to get the build flags.
		if (::VerQueryValue(m_abData, _T("\\"), (LPVOID*)&lpBuffer, &uSize))
		{
			// lpBuffer now holds a pointer to the fixed version resource.
			// Make a convenient pointer to the resource struct.
			m_vsInfo = (VS_FIXEDFILEINFO *) lpBuffer;
			// Put the valid version flags in dwFlags
			m_dwFlags = m_vsInfo->dwFileFlagsMask & m_vsInfo->dwFileFlags;
		}

		// Now look for the translation info. Ignore inferred version info
		// as such a resource info is not created using the VERSIONINFO resource,
		// but is dynamically created and may not contain valid fields.
		if(::VerQueryValue(m_abData, _T("\\VarFileInfo\\Translation"), (LPVOID*)&lpBuffer, &uSize)
			&& !(m_dwFlags & VS_FF_INFOINFERRED))
		{
			// We have the translation info, which is represented as two unsigned ints.
			// The format is as follows:
			// 	WORD Language			<- pointed to by lpBuffer
			// 	WORD Character Set
			// The codes for language values can be found in the Microsoft Programmers
			// Reference, Volume 4 under the VERSIONINFO resource description.
			// Borland's Resource Workshop automatically inserts the codes for
			// US English, Multilingual character set.

			// We must make an 8 digit ASCII string out of the two WORDs so we
			// can create the query string for the language dependant data block.
			wsprintf(m_szInfo, _T("\\StringFileInfo\\%04X%04X\\"),
					*(WORD *)(lpBuffer), *(WORD *)(lpBuffer + sizeof(WORD)));

			// Now we have a translation info string in szInfo consisting of
			//	"\\StringFileInfo\\<langauge info>\\"
			//	We will build on this to create the complete query string in szQuery

			// Get the text string for the language code
			if (::VerLanguageName(*(DWORD *)(lpBuffer), szQuery, sizeof(szQuery)) )
				_tcscpy(m_szLanguage, szQuery);

			// Now check the build flag info that we read earlier.
			// Check for the Pre-Release flag.
			if (m_dwFlags & VS_FF_PRERELEASE)
				m_PreRelease = _T(SZPRERELEASE);
			else
				m_PreRelease = _T("");

			// Check to see if this is a debug version
			if (m_dwFlags & VS_FF_DEBUG)
				m_Debug = SZDEBUGVER;
			else
				m_Debug = _T("");

			// Next, get a pointer to the file version
			_tcscpy(szQuery, m_szInfo);
			_tcscat(szQuery, _T(SZFILEVERSION) );
			if (::VerQueryValue(m_abData, szQuery, (LPVOID*)&lpBuffer, &uSize)) {
				m_Version = (char *) lpBuffer;
				strcpy( m_szVersion, (char *) lpBuffer );
			}

			// Now get the product name
			_tcscpy(szQuery, m_szInfo);
			_tcscat(szQuery, _T(SZPRODUCTNAME) );
			if (::VerQueryValue(m_abData, szQuery, (LPVOID*)&lpBuffer, &uSize))
				m_strProduct = (char *) lpBuffer;

			// Now get a pointer to the file description
			_tcscpy(szQuery, m_szInfo);
			_tcscat(szQuery, _T(SZFILEDESC) );
			if (::VerQueryValue(m_abData, szQuery, (LPVOID*)&lpBuffer, &uSize))
				m_Description = (char *) lpBuffer;

			// Get pointer to copyright info
			_tcscpy(szQuery, m_szInfo);
			_tcscat(szQuery, _T(SZLEGALCOPY) );
			if (::VerQueryValue(m_abData, szQuery, (LPVOID*)&lpBuffer, &uSize))
				m_Copyright = (char *) lpBuffer;

			bSuccess = TRUE;

		}// End if VerQueryValue(m_abData...)
	 } // End if (m_abData)

	return bSuccess;

} // End CAboutDialog::GetVersionInfo()


/*--------------------------------------------------------------
Fill list box with pointers to the data in the version info block
--------------------------------------------------------------*/
void CAboutDialog::FillListBox() 
{
	int		iIndex;
	TCHAR	szQuery[50];
	TCHAR	szTemp[50];
	UINT	uSize;				// Size of the retrieved version resource
	LPBYTE 	lpBuffer;			// Pointer to version data strings

	ASSERT(m_bHasVerInfo == TRUE);

	// Check the build flags to see if we should add
	// PrivateBuild or SpecialBuild strings to the listbox.
	if (m_dwFlags & VS_FF_PRIVATEBUILD)
		m_VersionInfoList.AddString(_T(SZPRIVATE) );

	if (m_dwFlags & VS_FF_SPECIALBUILD)
		m_VersionInfoList.AddString(_T(SZSPECIAL) );

	// Go through the entire list box and retrieve the version info
	// for each, putting the pointers retrieved into the listbox.
	// The Language item is the only oddball, since the versioninfo
	// holds language as a DWORD, not a string. m_szLanguage holds the
	// string, so for the language item (first in the listbox), we
	// will point to m_szLanguage.
	m_VersionInfoList.SetItemDataPtr(0, (LPVOID)m_szLanguage);

	// Now go through the rest of the listbox and save the pointers
	// to each version info item.
	int iNumItems = m_VersionInfoList.GetCount();
	for (iIndex = 1; iIndex < iNumItems; iIndex++)
	{
		// Get the list item and make the version info query string
		m_VersionInfoList.GetText(iIndex, szTemp);
		_tcscpy(szQuery, m_szInfo);
		_tcscat(szQuery, szTemp);

		// Next, query the versioninfo block and
		// save the pointer in the listbox data item.
		// Later, in the listbox change event, this pointer
		// will be used to read the version info from the
		// data block.
		if (::VerQueryValue(m_abData, szQuery, (LPVOID*)&lpBuffer, &uSize))
			m_VersionInfoList.SetItemDataPtr(iIndex, lpBuffer);
		else
			m_VersionInfoList.SetItemDataPtr(iIndex, NULL);
	}

	// Set to the last item in the list, then do the change event
	m_VersionInfoList.SetCurSel(iNumItems - 1);
	OnSelchangeVerinfoList();

} // End CAboutDialog::FillListBox() 

/*--------------------------------------------------------------
Event handler when listbox is clicked
--------------------------------------------------------------*/
void CAboutDialog::OnSelchangeVerinfoList() 
{
	TCHAR	far*	lpszData;
	
	// Was version information retrieved?
	if (m_bHasVerInfo)
	{
		// Get the current selection and display the version data
		// pointed to by the data item (or "[none]" if no data).
		lpszData = (char far *) m_VersionInfoList.GetItemDataPtr( m_VersionInfoList.GetCurSel() );
		if (lpszData)
		{
			GetDlgItem(IDC_OUTPUT_EDIT)->EnableWindow(TRUE);
			m_VersionOutputBox = lpszData;
		}
		else
		{
			GetDlgItem(IDC_OUTPUT_EDIT)->EnableWindow(FALSE);
			m_VersionOutputBox = _T(SZNONE);
		}
	
		UpdateData(FALSE);
	}

} // End CAboutDialog::OnSelchangeVerinfoList()


/*--------------------------------------------------------------
CString GetVersion()	Public

Returns: String with the version number,
		or NULL if no version info could be read.

		This string becomes invalid once this object
		is destroyed.

		The returned string is in a separate buffer from
		the actual version information.

  This function is for those callers that only want a
  string with the file's version number, rather than
  displaying the dialog box.
--------------------------------------------------------------*/
CString CAboutDialog::GetVersion()
{

	// Does version info need to be read?
	if (!m_bHasVerInfo) {
		m_bHasVerInfo = GetVersionInfo();
	}

	return m_Version;

}

/*--------------------------------------------------------------
CString GetProduct()	Public

Returns: String with the product name,
		or NULL if no version info could be read.

		This string becomes invalid once this object
		is destroyed.

		The returned string is in a separate buffer from
		the actual version information.

  This function is for those callers that only want a
  string with the file's version number, rather than
  displaying the dialog box.
--------------------------------------------------------------*/
CString CAboutDialog::GetProduct()
{

	// Does version info need to be read?
	if (!m_bHasVerInfo) {
		m_bHasVerInfo = GetVersionInfo();
	}

	return m_strProduct;

}
