/////////////////////////////////////////////////////////////////////////////
// FilteredEdit.cpp : implementation file
//
//	Subclassed edit box that only allows hexadecimal numerals
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "DiskCRC.h"
#include "FilteredEdit.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFilteredEdit

CFilteredEdit::CFilteredEdit()
{
}

CFilteredEdit::~CFilteredEdit()
{
}


BEGIN_MESSAGE_MAP(CFilteredEdit, CEdit)
	//{{AFX_MSG_MAP(CFilteredEdit)
	ON_WM_CHAR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFilteredEdit message handlers

void CFilteredEdit::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{

	BOOL	bKeep = FALSE;	// Assume we throw away the character
	
	// First, is it a number?
	if ((nChar >= '0') && (nChar <= '9') )
		bKeep = TRUE;
	// If not a number, is it a - f?
	else if ((nChar >= 'a') && (nChar <= 'f') )
		bKeep = TRUE;
	// If not, is it A - F?
	else if ((nChar >= 'A') && (nChar <= 'F') )
		bKeep = TRUE;
	// If not, is it a backspace?
	else if (nChar == 0x08)
		bKeep = TRUE;



	// Call parent handler only if keeping the character
	if (bKeep)
		CEdit::OnChar(nChar, nRepCnt, nFlags);
	else
		MessageBeep(-1);
}

