///////////////////////////////////////////////////////////////////////////////////////////////
//	PageLayout.h
//
//	Defines the logical page layout of the printed worklist on paper (in inches).
//
//	USED BY CTextPrinter object
//
///////////////////////////////////////////////////////////////////////////////////////////////

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

///////////////////////////////////////////////////////////////////////////////////////////////

// Margins in inches.
#define TOPMARGIN	0.5
#define LEFTMARGIN	0.5

// Number of default lines for the selected font and device.
#define LINESPERHEADER	2
#define LINESPERFOOTER	2

// Extra whitespace between lines, as a multiplier of line height.
#define LINESPACING		0.25

// Fractions of an inch for the TAB resolution.
// For example, 10 means that the TABs are given in
// 10's of an inch.
#define TABSIZE		10

// For whatever reason, the inventors of fonts long ago defined
// the size of a font in "points" - with 72 points per inch.
#define POINTSPERINCH	72

// Percentage of line height for the scribe line ascent.
#define ASCENT	10

//	Define tab positions (in tenths of inches)

// Number of tab stops.
// The number of columns is always NUMTABS + 1.
#define NUMTABS	3
#define NUMCOLS	(NUMTABS + 1)

// Special printing commands
#define SWITCHTOBOLD	'*'
#define SWITCHTOITALIC	'^'
#define SWITCHTONORMAL	'@'
