//////////////////////////////////////////////////////////////////////
// Printer.h: interface for the Printer class.
//
//	BASE CLASS:	CFormat.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PRINTER_H__C0E7A8AE_4830_477B_8423_759340E35A59__INCLUDED_)
#define AFX_PRINTER_H__C0E7A8AE_4830_477B_8423_759340E35A59__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "pagelayout.h"

//--------------------------------------------------------------------
//	Data required to define a region of the page.
//	The CFont pointers allow this object to
//	use a different font for each region (HEADER, BODY, and FOOTER).
struct	PAGEREGIONTYPE	{
		POINT		Origin;			// Relative to the margins.
		int			iCurrentLine;	// Current line number.
		int			iLineHeight;	// Height in logical units.
		CSize		PageSize;		// Size of this region, in logical units.
		int			iNumLines;		// Number of lines in this region.
		POINT		CurrentPoint;	// Essentially the "cursor".
		TEXTMETRIC	TextMetric;		// Metrics for the selected font.
		LPLOGFONT	plfLogFont;		// Pointer to the original Logical font definition.
		CFont		NormalFont;		// Normal Font for this region.
		CFont		ItalicFont;		// Italic font for this region.
		CFont		BoldFont;		// Bold font for this region.
		LOGFONT		lfNormal;		// Logical font definitions for normal,
		LOGFONT		lfItalic;		// Italic, and
		LOGFONT		lfBold;			// Bold.
};

enum	FontType  {NORMAL, ITALIC, BOLD};

//--------------------------------------------------------------------
class CTextPrinter 
{
public:
	void	SetTabStop(int iTab, int iCol);
	void	SetLegend(LPCSTR szLegend, int iCol);
	void	ScribeLineAbove(int iFromX = 0, int iToX = 9999, PAGEREGIONTYPE* pRegion = NULL);

	void	TabToLine(int y);
	void	TabToHorz(int x);

	BOOL	IsSelected() { return ( (m_hCDC != NULL) && m_bOK ) ;};
	
	void	Print(LPCSTR szText);
	void	PrintLn(LPCSTR szText);
	void	PrintCentered(LPCSTR szText);

	int		GetLinesPerPage() { return BODY.iNumLines; };
	int		GetCurrentLine() { return BODY.iCurrentLine; };
	void	NewPage();
	void	NewLine();

	void	SetFooter(LPCSTR szFooter);
	void	SetHeader(LPCSTR szHeader);
	void	SetNumPages(int iNumPages) { m_iNumPages = iNumPages; };

	// Overridable functions, to create product specifc headers
	// and footers.
	virtual	void	PrintFooter(LPCSTR szFooter = NULL);
	virtual	void	PrintHeader(LPCSTR szHeader = NULL);

	CTextPrinter(LPCSTR szDocName,	LPLOGFONT BodyFont = NULL,
									LPLOGFONT HeaderFont = NULL,
									LPLOGFONT FooterFont = NULL,
									int iLinesPerHeader = LINESPERHEADER,
									int iLinesPerFooter = LINESPERFOOTER);
	virtual ~CTextPrinter();
	
protected:
	CString m_szPrintTime;
	int		m_iNumPages;
	int		m_iLinesPerFooter;
	int		m_iLinesPerHeader;
	
	void	PrintLegend();
	void	UseRegionFont(PAGEREGIONTYPE& Region, FontType fType = NORMAL);
	void	RestoreFont();

	void	GetPageDimensions();
	void	SetRegionDimensions(PAGEREGIONTYPE& PageRegion, int iNumLines = 0);
	void	OffsetRegion(PAGEREGIONTYPE& Region, int x, int y);

	BOOL	__NewLine__(PAGEREGIONTYPE& Region);
	
	void	__PrintCentered__(LPCSTR szText, PAGEREGIONTYPE& Region);
	void	__Print__(LPCSTR szText, PAGEREGIONTYPE& Region);

	// LOGICAL PAGE and REGION Descriptions
	PAGEREGIONTYPE	HEADER;
	PAGEREGIONTYPE	FOOTER;
	PAGEREGIONTYPE	BODY;
	CDC*	m_hCDC;

	CString m_szDeviceName;
	CString m_szLegend[NUMCOLS];// Column headings
	CString	m_szFooter;			// Default Footer text.
	CString	m_szHeader;			// Default Header text.
	
	int		m_iPageNum;			// Current page number.
	
	// PHYSICAL PAGE Description
	CSize	m_Resolution;		// Logical units per inch
	CSize	m_PageSize;			// Absolute size in logical units.
	int		m_iVertUnitsLeft;	// Decrements as vertical space is allocated to regions.
	CSize	m_Margins;			// Offsets for the LOGICAL PAGE

	// Printer device context data
	DOCINFO	m_di;
	CFont*	m_pOldFont;

	// Error flag and flow control data
	BOOL	m_bOK;				// Set this to FALSE when a printer error occurs.
	BOOL	m_bPageStarted;		// Flow control for StartPage().
	BOOL	m_bDocStarted;		// Flow control for StartDoc().

	int		m_iTabs[NUMCOLS];	// Tab stops for tabbed text out.
};

#endif // !defined(AFX_PRINTER_H__C0E7A8AE_4830_477B_8423_759340E35A59__INCLUDED_)
