/////////////////////////////////////////////////////////////////////////////
// DlgPriority.cpp : implementation file
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "SERIM.h"
#include "DlgPriority.h"
#include "math.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgPriority dialog


CDlgPriority::CDlgPriority(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgPriority::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgPriority)
	m_strCost = _T("");
	m_strSchedule = _T("");
	m_strTechnical = _T("");
	//}}AFX_DATA_INIT
}


void CDlgPriority::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgPriority)
	DDX_Control(pDX, IDC_SLIDER, m_ctlSlider);
	DDX_Text(pDX, IDC_COST, m_strCost);
	DDX_Text(pDX, IDC_SCHEDULE, m_strSchedule);
	DDX_Text(pDX, IDC_TECHNICAL, m_strTechnical);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgPriority, CDialog)
	//{{AFX_MSG_MAP(CDlgPriority)
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_BN_CLICKED(IDC_BTNDEFAULT, OnBtndefault)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgPriority message handlers

BOOL CDlgPriority::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// Initialize variables
	m_bTracking = FALSE;
	
	// Get the default center point
	GetSliderCenter(&m_ptCenter);

	// Update the triangle strings
	m_strCost.LoadString(IDS_COSTPRI);
	m_strSchedule.LoadString(IDS_SCHEDPRI);
	m_strTechnical.LoadString(IDS_TECHPRI);

	// Compute the triangle corners, based on the anchor frame's
	// lower left corner and the width.
	CRect	rcRect;
	GetDlgItem(IDC_ANCHOR)->GetWindowRect(&rcRect);
	ScreenToClient(&rcRect);

	m_ptCost.x = rcRect.left;
	m_ptCost.y = rcRect.top + rcRect.Height();

	m_ptSched.x = m_ptCost.x + rcRect.Width();
	m_ptSched.y = m_ptCost.y;

	// Use Pythagoerean therom to calculate the triangle height.
	m_iBaseline = m_ptSched.x - m_ptCost.x;
	int iLength = m_iBaseline / 2;
	double dCSquared = (double) (m_iBaseline * m_iBaseline - iLength * iLength);
	m_iHeight = (int) sqrt(dCSquared);
	
	// Now we can locate the top corner of the triangle.
	m_ptTech.x = m_ptCost.x + iLength;
	m_ptTech.y = m_ptCost.y - m_iHeight;

	// Set the default weight
	CalcCenterFromWeights();

	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////////////
//	Track the slider icon if the mouse is down
//
void CDlgPriority::OnMouseMove(UINT nFlags, CPoint point) 
{
	// IF we are tracking the icon AND
	// the mouse is within bounds THEN
	if ((m_bTracking) &&
		(point.x >= m_ptCost.x - 1) &&		// In bounds on the left?
		(point.x <= m_ptSched.x + 1) &&		// In bounds on the right?
		(point.y >= m_ptTech.y - 1) &&		// In bounds on the top?
		(point.y <= m_ptCost.y + 1)			// In bounds on the bottom?
		)
	{
		// Yes - within the bounds.
		// Move the icon to track the mouse cursor.
		CRect rcRect;
		m_ctlSlider.GetWindowRect(&rcRect);
		m_ctlSlider.MoveWindow(
				point.x - rcRect.Width() / 2,
				point.y - rcRect.Height() / 2,
				rcRect.Width(),
				rcRect.Height()
				);

		// Calculate the distances to the three corners
		CalcDistances();
		CalculateWeights();
		ShowDistances();
	}
	// END IF
	
	CDialog::OnMouseMove(nFlags, point);
}

/////////////////////////////////////////////////////////////////////////////
void CDlgPriority::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// Find out where the tracking icon is right now.
	CRect rcRect;
	m_ctlSlider.GetWindowRect(&rcRect);
	ScreenToClient(&rcRect);

	// Was the button pressed on the tracking icon?
	if (	(point.x > rcRect.left) &&
			(point.x < rcRect.left + rcRect.Width() ) &&
			(point.y > rcRect.top ) &&
			(point.y < rcRect.top + rcRect.Height() )
			)
	{
		// Yes - start tracking mouse movement so that
		// the icon can follow the mouse cursor.
		m_bTracking = TRUE;
	}
	else
		m_bTracking = FALSE;
	
	CDialog::OnLButtonDown(nFlags, point);
}

/////////////////////////////////////////////////////////////////////////////
void CDlgPriority::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// Stop tracking the mouse movements
	m_bTracking = FALSE;
	
	CDialog::OnLButtonUp(nFlags, point);
}

/////////////////////////////////////////////////////////////////////////////
void CDlgPriority::OnBtndefault() 
{
	// Set priorities back to the default
	m_dSchedWeight = 0.333;
	m_dCostWeight = 0.333;
	m_dTechWeight = 0.333;

	// Move the icon to track the mouse cursor.
	CRect rcRect;
	m_ctlSlider.GetWindowRect(&rcRect);
	m_ctlSlider.MoveWindow(
				m_ptCost.x + m_iBaseline / 2 - rcRect.Width() / 2,
				m_ptCost.y - m_iHeight / 2 + rcRect.Height() / 2,
				rcRect.Width(),
				rcRect.Height()
				);

	// Update the UI
	ShowDistances();

	
}

/////////////////////////////////////////////////////////////////////////////
void CDlgPriority::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// Draw the triangle
	dc.MoveTo(m_ptCost);
	dc.LineTo(m_ptTech);
	dc.LineTo(m_ptSched);
	dc.LineTo(m_ptCost);

	// Do not call CDialog::OnPaint() for painting messages
}

//***************************************************************************
//	USE THE PYTHAGOREAN THEROM TO CALCULATE THE WEIGHTS, GIVEN THE ICON POSITION
//***************************************************************************

/////////////////////////////////////////////////////////////////////////////
void CDlgPriority::GetSliderCenter(CPoint* lpPoint)
{
	
	// Get the slider icon's center point
	CRect rectSlider;
	m_ctlSlider.GetWindowRect(&rectSlider);
	ScreenToClient(&rectSlider);

	// (X, Y) center of the slider icon
	lpPoint->x = rectSlider.left + rectSlider.Width() / 2;
	lpPoint->y = rectSlider.top + rectSlider.Height() / 2;

}

/////////////////////////////////////////////////////////////////////////////
//	Calculate the lengths from each triangle corner to the icon's center.
void CDlgPriority::CalcDistances()
{
	// Get the new slider icon center point
	GetSliderCenter(&m_ptCenter);

	// Calculate the distances from the Icon center to:
	//	- Cost corner
	//	- Technical corner
	//	- Schedule corner
	// No distance can go below zero.

	// Get the height, width, and hypoteneuse of the Icon to Cost triangle
	int iHeight = HeightFrom(m_ptCenter, m_ptCost);
	int iWidth = WidthFrom(m_ptCenter, m_ptCost);
	double iCSquared = iHeight * iHeight + iWidth * iWidth;
	m_iCost = m_iBaseline - (int) sqrt(iCSquared);
	m_iCost = (m_iCost < 0) ? 0 : m_iCost;

	// Get the height, width, and hypoteneuse of the Icon to Technical triangle
	iHeight = HeightFrom(m_ptCenter, m_ptTech);
	iWidth = WidthFrom(m_ptCenter, m_ptTech);
	iCSquared = iHeight * iHeight + iWidth * iWidth;
	m_iTech = m_iBaseline - (int) sqrt(iCSquared);
	m_iTech = (m_iTech < 0) ? 0 : m_iTech;

	// Get the height, width, and hypoteneuse of the Icon to Schedule triangle
	iHeight = HeightFrom(m_ptCenter, m_ptSched);
	iWidth = WidthFrom(m_ptCenter, m_ptSched);
	iCSquared = iHeight * iHeight + iWidth * iWidth;
	m_iSched = m_iBaseline - (int) sqrt(iCSquared);
	m_iSched = (m_iSched < 0) ? 0 : m_iSched;

}

/////////////////////////////////////////////////////////////////////////////
//	Calculates the height of the triangle leg, with ptA and ptB
//	as the hypotenuese.
//
int CDlgPriority::HeightFrom(CPoint ptA, CPoint ptB)
{
	int	iHeight;
	iHeight = abs(ptA.y - ptB.y);
	return iHeight;
}

/////////////////////////////////////////////////////////////////////////////
//	Calculates the width of the triangle leg, with ptA and ptB
//	as the hypotenuese.
//
int CDlgPriority::WidthFrom(CPoint ptA, CPoint ptB)
{
	int	iWidth;
	iWidth = abs(ptA.x - ptB.x);
	return iWidth;
}

/////////////////////////////////////////////////////////////////////////////
void CDlgPriority::ShowDistances()
{
	m_strCost.Format("Cost  %.0f%%", 100.0 * m_dCostWeight);
	m_strTechnical.Format("Technical  %.0f%%", 100.0 * m_dTechWeight);
	m_strSchedule.Format("Schedule  %.0f%%", 100.0 * m_dSchedWeight);

	UpdateData(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
void CDlgPriority::CalculateWeights()
{
	// Total the length of the three distances
	int iTotal = m_iCost + m_iTech + m_iSched;
	m_dCostWeight = ((double) m_iCost) / ((double) (iTotal));
	m_dTechWeight = ((double) m_iTech) /  ((double) (iTotal));
	m_dSchedWeight = ((double) m_iSched) /  ((double) (iTotal));
}

//***************************************************************************
//	USE LAW OF COSINES TO CALCULATE THE CENTER, GIVEN THE WEIGHTS
//***************************************************************************

/////////////////////////////////////////////////////////////////////////////
//	RETURNS:	Length from center of the icon to the corner, given the
//				weight of that corner.
double CDlgPriority::WeightToLength(double dWeight)
{
	double	dLen;
	dLen = (1.0 - dWeight) * m_iBaseline;
	return dLen;
}


/////////////////////////////////////////////////////////////////////////////
//	Calculate the icon center point, given the weights.
//	The Law of Cosines is used here.
//	Triangle sides are a, b, and c.
//	The inscribed angle is C_angle.
//	Height above the baseline to the icon center is H.
//	Length along the baseline to the icon center is L.
//
void CDlgPriority::CalcCenterFromWeights()
{
	double	a = WeightToLength(m_dCostWeight);
	double	b = (double) m_iBaseline;
	double	c = WeightToLength(m_dSchedWeight);

	double	C_angle;
	C_angle = acos( (c * c - a * a - b * b) / (2.0 * a * b) );

	double	H = a * sin(C_angle);
	double	L = a * cos(C_angle);

	if (H < 0) H *= -1.0;
	if (L < 0) L *= -1.0;

	// Use the calculation to figure the icon center point
	m_ptCenter.x = m_ptCost.x + (int) L;
	m_ptCenter.y = m_ptCost.y - (int) H;

	// Move the icon.
	// Adjust from the icon center to it's upper left corner.
	CRect rcRect;
	m_ctlSlider.GetWindowRect(&rcRect);
	ScreenToClient(&rcRect);
	m_ctlSlider.MoveWindow(
				m_ptCenter.x - rcRect.Width() / 2,
				m_ptCenter.y + rcRect.Height() / 2,
				rcRect.Width(),
				rcRect.Height()
				);

	// Update the UI
	ShowDistances();

}
