/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
#if !defined(AFX_DLGPRIORITY_H__F7924EEE_E291_4AF6_9E9D_4A71F302CCF6__INCLUDED_)
#define AFX_DLGPRIORITY_H__F7924EEE_E291_4AF6_9E9D_4A71F302CCF6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// DlgPriority.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CDlgPriority dialog

class CDlgPriority : public CDialog
{
// Construction
public:
	CDlgPriority(CWnd* pParent = NULL);   // standard constructor

	// Interfaces
	double	GetCostWeight() { return m_dCostWeight; };
	double	GetTechWeight() { return m_dTechWeight; };
	double	GetSchedWeight() { return m_dSchedWeight; };

	void	SetCostWeight(double dW) { m_dCostWeight = dW;};
	void	SetTechWeight(double dW) { m_dTechWeight = dW;};
	void	SetSchedWeight(double dW) { m_dSchedWeight = dW;};

// Dialog Data
	//{{AFX_DATA(CDlgPriority)
	enum { IDD = IDD_DLGPRIORITY };
	CStatic	m_ctlSlider;
	CString	m_strCost;
	CString	m_strSchedule;
	CString	m_strTechnical;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDlgPriority)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	void	CalcCenterFromWeights();
	double	WeightToLength(double dWeight);
	void	CalculateWeights();
	void	ShowDistances();
	int		WidthFrom(CPoint ptA, CPoint ptB);
	int		HeightFrom(CPoint ptA, CPoint ptB);
	void	CalcDistances();
	void	GetSliderCenter(CPoint* lpPoint);

	// Generated message map functions
	//{{AFX_MSG(CDlgPriority)
	virtual BOOL OnInitDialog();
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnBtndefault();
	afx_msg void OnPaint();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	double	m_dTechWeight;
	double	m_dCostWeight;
	double	m_dSchedWeight;
	
	int m_iHeight;
	int m_iBaseline;
	int m_iSched;
	int m_iTech;
	int m_iCost;

	CPoint m_ptSched;
	CPoint m_ptTech;
	CPoint m_ptCost;
	BOOL m_bTracking;
	CPoint m_ptCenter;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_DLGPRIORITY_H__F7924EEE_E291_4AF6_9E9D_4A71F302CCF6__INCLUDED_)
