/////////////////////////////////////////////////////////////////////////////
// DlgSummary.cpp : implementation file
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "SERIM.h"
#include "constants.h"
#include "DlgSummary.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgSummary dialog


CDlgSummary::CDlgSummary(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgSummary::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgSummary)
	m_strRiskSummary = _T("");
	m_strPhases = _T("");
	m_strActivity = _T("");
	//}}AFX_DATA_INIT
}


void CDlgSummary::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgSummary)
	DDX_Text(pDX, IDC_RISKSUMMARY, m_strRiskSummary);
	DDX_Text(pDX, IDC_PHASES, m_strPhases);
	DDX_Text(pDX, IDC_ACTIVITY, m_strActivity);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgSummary, CDialog)
	//{{AFX_MSG_MAP(CDlgSummary)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgSummary message handlers

void CDlgSummary::PostNcDestroy() 
{

	// The window is gone - now delete the C++ object itself.
	delete this;
	
	CDialog::PostNcDestroy();
}

/////////////////////////////////////////////////////////////////////////////
//	The window can be closed by the OK button
void CDlgSummary::OnOK() 
{
	// "We who are about to die, salute you!"
	// Tell the main window that we are about to die.
	AfxGetMainWnd()->SendMessage(WM_SUMMARYCLOSED);
	
	CDialog::OnOK();
}

/////////////////////////////////////////////////////////////////////////////
//	This window can also be closed by the CLOSE button on the system menu
void CDlgSummary::OnClose() 
{
	// "We who are about to die, salute you!"
	// Tell the main window that we are about to die.
	AfxGetMainWnd()->SendMessage(WM_SUMMARYCLOSED);
	
	CDialog::OnClose();
}


/////////////////////////////////////////////////////////////////////////////
void CDlgSummary::SetProjectRisk(double dRisk)
{
	m_dProjectRisk = dRisk * 100.0;
	WriteRiskSummary();
}


/////////////////////////////////////////////////////////////////////////////
void CDlgSummary::SetTechRisk(double dRisk)
{
	m_dTechRisk = dRisk * 100.0;
	WriteRiskSummary();
}


/////////////////////////////////////////////////////////////////////////////
void CDlgSummary::SetCostRisk(double dRisk)
{
	m_dCostRisk = dRisk * 100.0;
	WriteRiskSummary();
}


/////////////////////////////////////////////////////////////////////////////
void CDlgSummary::SetScheduleRisk(double dRisk)
{
	m_dScheduleRisk = dRisk * 100.0;
	WriteRiskSummary();
}

/////////////////////////////////////////////////////////////////////////////
void CDlgSummary::SetProcessRisk(double dRisk)
{
	m_dProcessRisk = dRisk * 100.0;
	WriteRiskSummary();
}

/////////////////////////////////////////////////////////////////////////////
void CDlgSummary::SetProductRisk(double dRisk)
{
	m_dProductRisk = dRisk * 100.0;
	WriteRiskSummary();
}

/////////////////////////////////////////////////////////////////////////////
void CDlgSummary::WriteRiskSummary()
{
	m_strRiskSummary.Format("%.1f%%\n\n%.1f%%\n%.1f%%\n%.1f%%\n\n%.1f%%\n%.1f%%",
		m_dProjectRisk,
		m_dTechRisk,
		m_dCostRisk,
		m_dScheduleRisk,
		m_dProcessRisk,
		m_dProductRisk
		);

	m_strPhases.Format("%.1f%%\n%.1f%%\n\n%.1f%%\n%.1f%%\n%.1f%%\n\n%.1f%%\n",
		m_dPrereqRisk,
		m_dReqRisk,
		m_dDesignRisk,
		m_dCodeRisk,
		m_dTestRisk,
		m_dMaintRisk
		);

	m_strActivity.Format("%.1f%%\n\n%.1f%%\n%.1f%%\n%.1f%%\n\n%.1f%%\n%.1f%%\n",
		m_dIdentRisk,
		m_dPlanningRisk,
		m_dAssessRisk,
		m_dMitigationRisk,
		m_dReportRisk,
		m_dPredictionRisk
		);

	UpdateData(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
void CDlgSummary::SetPrereqRisk(double dRisk)
{
	m_dPrereqRisk = dRisk * 100.0;
	WriteRiskSummary();
}

/////////////////////////////////////////////////////////////////////////////
void CDlgSummary::SetReqRisk(double dRisk)
{
	m_dReqRisk = dRisk * 100.0;
	WriteRiskSummary();
}

/////////////////////////////////////////////////////////////////////////////
void CDlgSummary::SetDesignRisk(double dRisk)
{
	m_dDesignRisk = dRisk * 100.0;
	WriteRiskSummary();
}

/////////////////////////////////////////////////////////////////////////////
void CDlgSummary::SetCodeRisk(double dRisk)
{
	m_dCodeRisk = dRisk * 100.0;
	WriteRiskSummary();
}

/////////////////////////////////////////////////////////////////////////////
void CDlgSummary::SetTestRisk(double dRisk)
{
	m_dTestRisk = dRisk * 100.0;
	WriteRiskSummary();
}

/////////////////////////////////////////////////////////////////////////////
void CDlgSummary::SetMaintRisk(double dRisk)
{
	m_dMaintRisk = dRisk * 100.0;
	WriteRiskSummary();
}

/////////////////////////////////////////////////////////////////////////////
void CDlgSummary::SetIdentRisk(double dRisk)
{
	m_dIdentRisk = dRisk * 100.0;
	WriteRiskSummary();
}

/////////////////////////////////////////////////////////////////////////////
void CDlgSummary::SetPlanningRisk(double dRisk)
{
	m_dPlanningRisk = dRisk * 100.0;
	WriteRiskSummary();
}

/////////////////////////////////////////////////////////////////////////////
void CDlgSummary::SetAssessRisk(double dRisk)
{
	m_dAssessRisk = dRisk * 100.0;
	WriteRiskSummary();
}

/////////////////////////////////////////////////////////////////////////////
void CDlgSummary::SetMitigationRisk(double dRisk)
{
	m_dMitigationRisk = dRisk * 100.0;
	WriteRiskSummary();
}

/////////////////////////////////////////////////////////////////////////////
void CDlgSummary::SetReportingRisk(double dRisk)
{
	m_dReportRisk = dRisk * 100.0;
	WriteRiskSummary();
}

/////////////////////////////////////////////////////////////////////////////
void CDlgSummary::SetPredictionRisk(double dRisk)
{
	m_dPredictionRisk = dRisk * 100.0;
	WriteRiskSummary();
}
