//////////////////////////////////////////////////////////////////////
// Question.cpp: implementation of the CQuestion class.
//
//	ROLE: Information Holder
//
//	ASSUMPTIONS:
//	The SERIM Model is fixed and not subject to change.
//	The text of the questions never changes.
//	The weighting and interpretation of the responses never changes.
//	
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Question.h"
#include "resource.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Ordinal Values for the response buttons/list box.
// Each control will give an ordinal index to these arrays.
// All questions in SERIM use the same weighting, except for
// a single Estimation question that will use a listbox response.
static double RadioResponses[] = { 0, 0.2, 0.5, 0.8, 1 };
static double ListboxResponses[] = { 0.2, 0.3, 0.3, 0.4, 0.5, 0.6, 0.7 };

BOOL	CQuestion::m_bModified = FALSE;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CQuestion::CQuestion(QuestionType* qType) :
	m_iAnswer(0),
	m_uFlags(0),
	m_dResponses(NULL),
	m_iNumResponses(0)
{
	// Insanity check. Can only happen if the programmer messes up the question table.
	if (qType == NULL) return;

	// Load the data members
	m_uFlags = qType->uFlags;
	m_strText.LoadString(qType->uQuestionID);

	// Set the response array
	if (m_uFlags & UI_RADIOBUTTONS)
	{
		m_dResponses = RadioResponses;
		m_iNumResponses = sizeof(RadioResponses) / sizeof(double);
	}
	else if (m_uFlags & UI_LISTBOX)
	{
		m_dResponses = ListboxResponses;
		m_iNumResponses = sizeof(ListboxResponses) / sizeof(double);
	}
	else throw;		// CAN'T HAPPEN UNLESS PROGRAMMER GOOFS THE QUESTION TABLE

}

//////////////////////////////////////////////////////////////////////
CQuestion::~CQuestion()
{

}


//////////////////////////////////////////////////////////////////////
//	RETURNS:	Text string for the given Ordinal response.
//				Empty string if iOrdinal is greater than the number
//				of responses.
LPCSTR CQuestion::GetResponseText(UINT iOrdinal)
{
	static	CString	strResponse;

	// SERIM has the same responses for all radio button questions,
	// so it's ok to have just one set of responses for them.
	// These responses are in ordinal sequence from least to most.
	static	UINT	szRadioArray[] = {
		IDS_NONE,
		IDS_LITTLE,
		IDS_SOME,
		IDS_MOST,
		IDS_ALL
	};

	// SERIM only has one question that can use a Listbox,
	// so it's ok to have only one set of responses for it.
	// These responses are in ordinal sequence from least to most.
	static	UINT	szListboxArray[] = {
		IDS_GUESS,
		IDS_DICTATED,
		IDS_TOWIN,
		IDS_OTHER,
		IDS_TOPDOWN,
		IDS_ANALOGY,
		IDS_BOTTOMUP
	};

	// Should we use the radio button text?
	if (UsesRadioButtons() && (iOrdinal < m_iNumResponses) )
	{
		strResponse.LoadString(szRadioArray[iOrdinal]);
	}
	// Or should we use the Listbox test?
	else if (UsesListbox() && (iOrdinal < m_iNumResponses))
	{
		strResponse.LoadString(szListboxArray[iOrdinal]);
	}
	// Or was there something wrong with the iOrdinal value?
	else
	{
		strResponse.Empty();
	}

	return strResponse;
}
