//////////////////////////////////////////////////////////////////////
// Question.h: interface for the CQuestion class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_QUESTION_H__826D3016_6026_4F0D_8C86_179570807DA6__INCLUDED_)
#define AFX_QUESTION_H__826D3016_6026_4F0D_8C86_179570807DA6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//////////////////////////////////////////////////////////////////////
//	FLAGS FOR DEFINING THE QUESTION CATEGORY, PHASE, ACTIVITY, AND UI
//////////////////////////////////////////////////////////////////////

// Question Categories
#define C_ORGANIZATION		0x00000001
#define C_ESTIMATION		0x00000002
#define C_MONITORING		0x00000004
#define C_DEVELOPMENT		0x00000008
#define C_TOOLS				0x00000010
#define C_RISKCULTURE		0x00000020
#define C_USABILITY			0x00000040
#define C_CORRECTNESS		0x00000080
#define C_RELIABILITY		0x00000100
#define C_PERSONNEL			0x00000200

// Phases
#define	P_PREREQUIREMENTS	0x00000400
#define P_REQUIREMENTS		0x00000800
#define P_DESIGN			0x00001000
#define	P_CODE				0x00002000
#define P_TESTING			0x00004000
#define P_MAINTENANCE		0x00008000

// Activities
#define A_IDENTIFICATION	0x00010000
#define A_PLANNING			0x00020000
#define A_ASSESSMENT		0x00040000
#define A_MITIGATION		0x00080000
#define A_REPORTING			0x00100000
#define A_PREDICTION		0x00200000

// User Interface Controls
#define UI_RADIOBUTTONS		0x01000000
#define UI_LISTBOX			0x02000000

//////////////////////////////////////////////////////////////////////
// Question definition tables
struct QuestionType {
	UINT	uQuestionID;	// String ID for the question text
	UINT	uFlags;			// Bit flags for category, activities, phases, and UI
};


//////////////////////////////////////////////////////////////////////
class CQuestion   
{
public:
	UINT	GetNumResponses() { return m_iNumResponses; };

	// The Ordinal answer is the answer that means something to the UI.
	// The Value answer is the floating point value for the ordinal answer.
	void	SetAnswerOrdinal(UINT iAnswer) { m_iAnswer = (iAnswer < m_iNumResponses) ? iAnswer : (m_iNumResponses - 1); m_bModified = TRUE;};
	int		GetAnswerOrdinal() { return m_iAnswer; };
	double	GetAnswerValue() { return m_dResponses[m_iAnswer]; };

	// Helper functions for use by the UI.
	CString	GetQuestionText() { return m_strText; };
	LPCSTR	GetResponseText(UINT iOrdinal);
	BOOL	UsesRadioButtons() { return (UI_RADIOBUTTONS & m_uFlags) ? TRUE : FALSE; };
	BOOL	UsesListbox() { return (UI_LISTBOX & m_uFlags) ? TRUE : FALSE; };

	// Helper methods to determine if the question is in a particular area.
	BOOL	HasFlag(UINT uFlags) { return (uFlags & m_uFlags) ? TRUE : FALSE; };
	BOOL	IsModified() {return m_bModified;};
	void	ClearModified() {m_bModified = FALSE;};

protected:
	// Class factory functions
	static	CQuestion* Create(QuestionType* qType) { return new CQuestion(qType); };
	static	void Destroy(CQuestion* q) { delete q; };

	CQuestion(QuestionType* qType);
	virtual ~CQuestion();
	
private:
	double*	m_dResponses;
	UINT	m_iNumResponses;
	UINT	m_iAnswer;
	CString	m_strText;
	UINT	m_uFlags;

	// Static, so if any question is modified, the whole set of questions shows as modified.
	static	BOOL	m_bModified;
};

#endif // !defined(AFX_QUESTION_H__826D3016_6026_4F0D_8C86_179570807DA6__INCLUDED_)
