/////////////////////////////////////////////////////////////////////////////
// SERIMDlg.cpp : implementation file
//
//	User Interface for the SERIM model.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "SERIM.h"
#include "constants.h"
#include "SERIMDlg.h"
#include "aboutdialog.h"
#include "dlgpriority.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSERIMDlg dialog

CSERIMDlg::CSERIMDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSERIMDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSERIMDlg)
	m_strCatSuccess = _T("");
	m_strPriority = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_strFilename.Empty();
	m_strName.Empty();
}

void CSERIMDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSERIMDlg)
	DDX_Control(pDX, IDC_COMBO1, m_ListBox);
	DDX_Text(pDX, IDC_CATSUCCESS, m_strCatSuccess);
	DDX_Text(pDX, IDC_PRIORITY, m_strPriority);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSERIMDlg, CDialog)
	//{{AFX_MSG_MAP(CSERIMDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_RADIO_ORG, OnRadioOrg)
	ON_BN_CLICKED(IDC_RADIO_ESTIMATE, OnRadioEstimate)
	ON_BN_CLICKED(IDC_RADIO_MONITOR, OnRadioMonitor)
	ON_BN_CLICKED(IDC_RADIO_DEVELOP, OnRadioDevelop)
	ON_BN_CLICKED(IDC_RADIO_TOOLS, OnRadioTools)
	ON_BN_CLICKED(IDC_RADIO_CULTURE, OnRadioCulture)
	ON_BN_CLICKED(IDC_RADIO_USABILITY, OnRadioUsability)
	ON_BN_CLICKED(IDC_RADIO_CORRECT, OnRadioCorrect)
	ON_BN_CLICKED(IDC_RADIO_RELIABLE, OnRadioReliable)
	ON_BN_CLICKED(IDC_RADIO_PERSON, OnRadioPerson)
	ON_CBN_SELCHANGE(IDC_COMBO1, OnSelchangeCombo1)
	ON_WM_DESTROY()
	ON_WM_CLOSE()
	ON_COMMAND(IDM_ABOUT, OnAbout)
	ON_COMMAND(IDM_NEW, OnNew)
	ON_COMMAND(IDM_OPEN, OnOpen)
	ON_COMMAND(IDM_SAVE, OnSave)
	ON_COMMAND(IDM_SAVEAS, OnSaveas)
	ON_COMMAND(IDM_EXIT, OnExit)
	ON_COMMAND(IDM_PRIORITY, OnPriority)
	ON_COMMAND(IDM_SUMMARY, OnSummary)
	//}}AFX_MSG_MAP
	// Manually added message handlers
	ON_COMMAND_RANGE(IDC_RESPONSE_0_0, IDC_RESPONSE_11_4, OnRadioResponse)
	ON_MESSAGE(WM_AFTERINIT, MSG_AfterInit)
	ON_MESSAGE(WM_SUMMARYCLOSED, MSG_SummaryClosed)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSERIMDlg message handlers

BOOL CSERIMDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// Initialize pointer to the summary dialog box object. It will be created later.
	m_pDlgSummary = NULL;

	// Was a filename given to open?
	
	// Finish the initialization after the dialog box is onscreen.
	SetTitleBar();
	UpdateWeightDisplay();
	PostMessage(WM_AFTERINIT);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
void CSERIMDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDialog dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

/////////////////////////////////////////////////////////////////////////////
// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSERIMDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

/////////////////////////////////////////////////////////////////////////////
// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSERIMDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

//***************************************************************************
//	USER DEFINED MESSAGE HANDLERS FOR COMMUNICATION WITH THE USER INTERFACE
//***************************************************************************

/////////////////////////////////////////////////////////////////////////////
//	On screen controls will exist by this time.
//	This function is only called once.
//
void CSERIMDlg::MSG_AfterInit(WPARAM wParam, LPARAM lParam)
{
	// Reset filename
//	m_strFilename.Empty();
//	m_strName.Empty();

	// Was a filename to open passed in?
	if (m_strFilename.GetLength() > 0)
	{
		// Yes - open the file
		ReadFile(m_strFilename);
	}
	else
	{
		// No - make a blank project
		SetTitleBar();
		
		// Start with the Organization category by triggering a button click.
		m_uCurrentCategory = C_ORGANIZATION;
		CheckRadioButton(IDC_RADIO_ORG, IDC_RADIO_PERSON, IDC_RADIO_ORG);
		PostMessage(WM_COMMAND, IDC_RADIO_ORG, 0);
	}


}

/////////////////////////////////////////////////////////////////////////////
void CSERIMDlg::MSG_SummaryClosed(WPARAM wParam, LPARAM lParam)
{
	// The modeless Summary dialog reported its death.
	// NULL the object pointer.
	m_pDlgSummary = NULL;

	// Un Check the menu item
	CMenu* MyMenu = GetMenu();
	MyMenu->CheckMenuItem(IDM_SUMMARY, MF_UNCHECKED);

}

//***************************************************************************
//	UI CONTROL EVENT HANDLERS
//***************************************************************************

/////////////////////////////////////////////////////////////////////////////
//	Handlers for the column of category buttons
//
void CSERIMDlg::OnRadioOrg() 
{
	SetCategory(C_ORGANIZATION);
}

/////////////////////////////////////////////////////////////////////////////

void CSERIMDlg::OnRadioEstimate() 
{
	SetCategory(C_ESTIMATION);
}

/////////////////////////////////////////////////////////////////////////////

void CSERIMDlg::OnRadioMonitor() 
{
	SetCategory(C_MONITORING);
}

/////////////////////////////////////////////////////////////////////////////

void CSERIMDlg::OnRadioDevelop() 
{
	SetCategory(C_DEVELOPMENT);
}

/////////////////////////////////////////////////////////////////////////////

void CSERIMDlg::OnRadioTools() 
{
	SetCategory(C_TOOLS);
}

/////////////////////////////////////////////////////////////////////////////

void CSERIMDlg::OnRadioCulture() 
{
	SetCategory(C_RISKCULTURE);
}

/////////////////////////////////////////////////////////////////////////////

void CSERIMDlg::OnRadioUsability() 
{
	SetCategory(C_USABILITY);
}

/////////////////////////////////////////////////////////////////////////////

void CSERIMDlg::OnRadioCorrect() 
{
	SetCategory(C_CORRECTNESS);
}

/////////////////////////////////////////////////////////////////////////////

void CSERIMDlg::OnRadioReliable() 
{
	SetCategory(C_RELIABILITY);
}

/////////////////////////////////////////////////////////////////////////////

void CSERIMDlg::OnRadioPerson() 
{
	SetCategory(C_PERSONNEL);
}

/////////////////////////////////////////////////////////////////////////////
//	Sets the user interface to the given category.
//	When the category is set, the logic is:
//		Save the new category's name (the iCategory flag)
//		Hide the listbox (assumes it won't be needed)
//		FOR each question in the QuestionList
//			IF question is in this category THEN
//				Save the CQuestion*, to associate it with this UI question number
//				Set the question text
//				Show the radio buttons (or list box, if appropriate)
//				Show the current question response
//				Increment the current UI question number
//			END IF
//		END FOR
//
//		FOR all remaining unused UI objects
//			Hide the UI object
//		END FOR
//
//		Update the category's chance of success
//
//	ASSUMPTIONS
//		SERIM is a fixed model, and only one question requires a listbox control.
//		It is assumed then that the listbox is always the first question, so it
//		does not have to be positioned, and there only needs to be one listbox.
//
void CSERIMDlg::SetCategory(UINT iCategory)
{
	m_uCurrentCategory = iCategory;
	
	// Start at the first set of question UI objects
	UINT	uCurrentUIobject = 0;
	UINT	uNumUIobjects = IDC_QUESTION11 - IDC_QUESTION0 + 1;

	// Initially assume that the list box is not used
	GetDlgItem(IDC_COMBO1)->ShowWindow(SW_HIDE);

	// FOR each question in the list
	for (UINT i = 0; i < NUMQUESTIONS; i++)
	{
		// IF the question is in this category THEN
		CQuestion* pCurrentQuestion = m_QuestionList.GetQuestion(i);
		if (pCurrentQuestion->HasFlag(iCategory))
		{
			// Save this CQuestion pointer in an array that maps the question number
			// on screen to the corresponding CQuestion.
			m_UIQuestionList[uCurrentUIobject] = pCurrentQuestion;

			// Set the question text
			CString strText = pCurrentQuestion->GetQuestionText();
			CWnd* pWnd = GetDlgItem(IDC_QUESTION0 + uCurrentUIobject);
			pWnd->SetWindowText(strText);
			pWnd->ShowWindow(SW_SHOW);

			// IF this question uses radio buttons THEN
			if (pCurrentQuestion->UsesRadioButtons())
			{
				// Make the radio buttons visible
				for (UINT n = 0; n < 5; n++)
				{
					GetDlgItem(IDC_RESPONSE_0_0 + n + uCurrentUIobject * 5)->ShowWindow(SW_SHOW);
				}
				
				// Show the current answer
				UINT iFirstButtonID = IDC_RESPONSE_0_0 + uCurrentUIobject * 5;
				UINT iLastButtonID = iFirstButtonID + 4;
				UINT iButtonID = iFirstButtonID + pCurrentQuestion->GetAnswerOrdinal();
				CheckRadioButton(iFirstButtonID, iLastButtonID, iButtonID);
			}
			// ELSE IF it uses a Listbox THEN
			else if (pCurrentQuestion->UsesListbox())
			{
				// Show the listbox (there's only one)
				GetDlgItem(IDC_COMBO1)->ShowWindow(SW_SHOW);

				// Load the listbox values
				m_ListBox.ResetContent();
				for (UINT iIndex = 0; iIndex < pCurrentQuestion->GetNumResponses(); iIndex++)
				{
					m_ListBox.AddString(pCurrentQuestion->GetResponseText(iIndex));
				}

				// Position the listbox -
				// Since SERIM is a fixed model, the lisbox is always in the top row.
				// No need to move it from its default position.

				// Hide the radio buttons for this question
				for (UINT n = 0; n < 5; n++)
				{
					GetDlgItem(IDC_RESPONSE_0_0 + n + uCurrentUIobject * 5)->ShowWindow(SW_HIDE);
				}

				// Show the current answer
				m_ListBox.SetCurSel(pCurrentQuestion->GetAnswerOrdinal());
			}
			// END IF
			
			// Step to the next UI object (e.g. next question number)
			uCurrentUIobject++;
		}
		// END IF
	}
	// END FOR

	// FOR each remaining UI object
	for (i = uCurrentUIobject; i < uNumUIobjects; i++)
	{
		// NULL the question pointer
		m_UIQuestionList[i] = NULL;

		// Set question to invisible
		GetDlgItem(IDC_QUESTION0 + i)->ShowWindow(SW_HIDE);

		// Set radio buttons to invisible
		for (UINT n = 0; n < 5; n++)
		{
			GetDlgItem(IDC_RESPONSE_0_0 + i * 5 + n)->ShowWindow(SW_HIDE);
		}
	}
	// END FOR

	// Recalculate this category's chance of success
	UpdateCategoryStats();
}

/////////////////////////////////////////////////////////////////////////////
//	Command handler for all question RADIO buttons.
//	The Listbox response is done in a different handler.
//
void CSERIMDlg::OnRadioResponse(UINT nID) 
{
	// What question number was clicked?
	UINT iQuestionNumber = (nID - IDC_RESPONSE_0_0) / 5;
	UINT iFirstButtonID = IDC_RESPONSE_0_0 + iQuestionNumber * 5;
	UINT iLastButtonID = iFirstButtonID + 4;

	// What button in the question was clicked?
	UINT iResponseNumber = (nID - IDC_RESPONSE_0_0) % 5;
	UINT iButtonID = iFirstButtonID + iResponseNumber;

	// Set the appropriate radio button marks.
	CheckRadioButton(iFirstButtonID, iLastButtonID, iButtonID);

	// Set the value of the user's response to this question.
	// When the Category was set, the CQuestion* was stored in an array
	// that matches the question number on the UI.
	m_UIQuestionList[iQuestionNumber]->SetAnswerOrdinal(iResponseNumber);

	// Recalculate this category's chance of success
	UpdateCategoryStats();

}

/////////////////////////////////////////////////////////////////////////////
//	Command handler when the LISTBOX selection is made.
//
void CSERIMDlg::OnSelchangeCombo1() 
{
	// Set the value of the user's response to this question.
	// When the Category was set, the CQuestion* was stored in an array
	// that matches the question number on the UI.
	// ASSUMPTION: Since SERIM is a fixed model, the listbox is ALWAYS the first
	// item in the only category that uses it.
	m_UIQuestionList[0]->SetAnswerOrdinal(m_ListBox.GetCurSel());
	
	// Recalculate this category's chance of success
	UpdateCategoryStats();
}

/////////////////////////////////////////////////////////////////////////////
//	Call this anytime the current category selections change.
//
void CSERIMDlg::UpdateCategoryStats()
{
	// Recalculate this category's chance of success.
	// Each category has a specific equation to calculate its chance of success.
	double dChance = 100.0 * m_QuestionList.Calculate(m_QuestionList.GetEquationType(m_uCurrentCategory));
	m_strCatSuccess.Format("%.1f%%", dChance);

	// IF the summary dialog is open THEN
	if (m_pDlgSummary != NULL)
	{
		// Update the summary
		UpdateSummaryDlg();
	}
	// END IF

	UpdateData(FALSE);
}

//***************************************************************************
//	MISC EVENT HANDLERS
//***************************************************************************

/////////////////////////////////////////////////////////////////////////////
//	Program has been requested to close.
//	Can prompt user to confirm, and call base class method if confirmed.
//
void CSERIMDlg::OnClose() 
{
	// FIRST, check to see if the current project needs to be saved.
	if (IsFileSaved())
	{
		CDialog::OnClose();
	}

}

/////////////////////////////////////////////////////////////////////////////
//	Program is closing. Put any final cleanup here.
//
void CSERIMDlg::OnDestroy() 
{
	CDialog::OnDestroy();
}


/////////////////////////////////////////////////////////////////////////////
void CSERIMDlg::UpdateSummaryDlg()
{
	// Load the dialog with the risk values.
	if (m_pDlgSummary != NULL)
	{
		m_QuestionList.CalculateAll();
		m_pDlgSummary->SetProjectRisk(m_QuestionList.GetResult(PA));
		m_pDlgSummary->SetTechRisk(m_QuestionList.GetResult(PA1));
		m_pDlgSummary->SetCostRisk(m_QuestionList.GetResult(PA2));
		m_pDlgSummary->SetScheduleRisk(m_QuestionList.GetResult(PA3));
		m_pDlgSummary->SetProcessRisk(m_QuestionList.GetResult(PN));
		m_pDlgSummary->SetProductRisk(m_QuestionList.GetResult(PO));

		m_pDlgSummary->SetPrereqRisk(m_QuestionList.GetResult(PB));
		m_pDlgSummary->SetReqRisk(m_QuestionList.GetResult(PC));
		m_pDlgSummary->SetDesignRisk(m_QuestionList.GetResult(PD));
		m_pDlgSummary->SetCodeRisk(m_QuestionList.GetResult(PE));
		m_pDlgSummary->SetTestRisk(m_QuestionList.GetResult(PF));
		m_pDlgSummary->SetMaintRisk(m_QuestionList.GetResult(PG));

		m_pDlgSummary->SetIdentRisk(m_QuestionList.GetResult(PH));
		m_pDlgSummary->SetPlanningRisk(m_QuestionList.GetResult(PI));
		m_pDlgSummary->SetAssessRisk(m_QuestionList.GetResult(PJ));
		m_pDlgSummary->SetMitigationRisk(m_QuestionList.GetResult(PK));
		m_pDlgSummary->SetReportingRisk(m_QuestionList.GetResult(PL));
		m_pDlgSummary->SetPredictionRisk(m_QuestionList.GetResult(PM));
	}

}
//***************************************************************************
//	MENU EVENT HANDLERS
//***************************************************************************

/////////////////////////////////////////////////////////////////////////////
void CSERIMDlg::OnExit() 
{
	PostMessage(WM_CLOSE);
}

/////////////////////////////////////////////////////////////////////////////
void CSERIMDlg::OnAbout() 
{
	CAboutDialog	dlg;
	dlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
void CSERIMDlg::OnNew() 
{
	// FIRST, check to see if the current project needs to be saved.
	if (IsFileSaved())
	{
		// Clear the slate
		m_QuestionList.ClearAll();
		UpdateSummaryDlg();
		UpdateWeightDisplay();

		// Reset filename
		m_strFilename.Empty();
		m_strName.Empty();
		SetTitleBar();
		
		// Start with the Organization category by triggering a button click.
		m_uCurrentCategory = C_ORGANIZATION;
		CheckRadioButton(IDC_RADIO_ORG, IDC_RADIO_PERSON, IDC_RADIO_ORG);
		PostMessage(WM_COMMAND, IDC_RADIO_ORG, 0);
	}
}

/////////////////////////////////////////////////////////////////////////////
void CSERIMDlg::OnOpen() 
{
	// FIRST, check to see if the current project needs to be saved.
	if (IsFileSaved())
	{
		// Create the structure for the common dialog box.
		CFileDialog	cfDlg(
			TRUE,		// File Open Dialog
			"*.srm",	// Default extension
			NULL,		// Default filename
			OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_PATHMUSTEXIST,
			"SERIM Files (*.srm)|*.srm||"
			);

		if (cfDlg.DoModal() == IDOK)
		{
			// Read the file
			m_strFilename = cfDlg.GetPathName();
			m_strName = cfDlg.GetFileTitle();
			ReadFile(m_strFilename);
		}
	}
	
}

/////////////////////////////////////////////////////////////////////////////
void CSERIMDlg::OnSave() 
{
	// IF we don't have a filename, then use the Save As instead.
	if (m_strFilename.GetLength() == 0)
	{
		PostMessage(WM_COMMAND, IDM_SAVEAS);
		return;
	}

	// Save the file.
	SaveSRMFile(m_strFilename);
	SetTitleBar();
}

/////////////////////////////////////////////////////////////////////////////
void CSERIMDlg::OnSaveas() 
{
	// Create the structure for the common dialog box.
	CFileDialog	cfDlg(
		FALSE,		// File Save As Dialog
		"*.srm",	// Default extension
		NULL,		// Default filename
		OFN_HIDEREADONLY | OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT,
		"SERIM File (*.srm)|*.srm|Text File (*.txt)|*.txt|HTML File (*.htm)|*.htm||"
		);
	
	if (cfDlg.DoModal() == IDOK)
	{
		// Get the selected filename and path.
		CString strPath = cfDlg.GetPathName();

		// What format was selected?
		CString strExt = cfDlg.GetFileExt();
		if (strExt.CompareNoCase("srm") == 0)
		{
			// Save in SERIM format.
			// Also save the complete pathname.
			// This way, the Save command always saves in SRM format.
			m_strFilename = strPath;
			m_strName = cfDlg.GetFileTitle();
		SaveSRMFile(m_strFilename);
		}
		else if (strExt.CompareNoCase("txt") == 0)
		{
			// Save as an ASCII text file
			SaveTextFile(strPath);
		}
		else if (strExt.CompareNoCase("htm") == 0)
		{
			// Save as an HTML file
			SaveHTMLFile(strPath);
		}

		SetTitleBar();
	}
	
}

/////////////////////////////////////////////////////////////////////////////
void CSERIMDlg::OnPriority() 
{
	CDlgPriority	dlg;

	// Load the weights
	dlg.SetCostWeight(m_QuestionList.GetCostPriority());
	dlg.SetTechWeight(m_QuestionList.GetTechPriority());
	dlg.SetSchedWeight(m_QuestionList.GetSchedPriority());

	// Prompt the user
	int iResult = dlg.DoModal();

	// IF the user changed the weights THEN
	if (iResult == IDOK)
	{
		// Get the new weights
		m_QuestionList.SetCostPriority(dlg.GetCostWeight());
		m_QuestionList.SetSchedPriority(dlg.GetSchedWeight());
		m_QuestionList.SetTechPriority(dlg.GetTechWeight());
		UpdateWeightDisplay();

		// Recalculate total probability
		m_QuestionList.CalculateTotal();
		UpdateSummaryDlg();
	}
	// END IF
	
}

/////////////////////////////////////////////////////////////////////////////
void CSERIMDlg::OnSummary() 
{
	// IF the dialog object does not exist, THEN
	if (m_pDlgSummary == NULL)
	{
		// Create and show the dialog as a modeless dialog
		m_pDlgSummary = new CDlgSummary;
		m_pDlgSummary->Create(IDD_DLGSUMMARY, this);
		m_pDlgSummary->ShowWindow(SW_SHOW);

		UpdateSummaryDlg();

		// Check the menu item
		CMenu* MyMenu = GetMenu();
		MyMenu->CheckMenuItem(IDM_SUMMARY, MF_CHECKED);
	}
	// END IF
}

/////////////////////////////////////////////////////////////////////////////
//	FILE HANDLING FUNCTIONS
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
void CSERIMDlg::SaveSRMFile(LPCSTR pszFilename)
{
	// Open the file
	CFile	cfFile(pszFilename, CFile::modeCreate | CFile::modeWrite);

	// Save the questions
	for (UINT i = 0; i < NUMQUESTIONS; i++)
	{
		int iValue = m_QuestionList.GetQuestion(i)->GetAnswerOrdinal();
		cfFile.Write(&iValue, sizeof(int));
	}

	// Save the weightings
	double dValue;
	dValue = m_QuestionList.GetSchedPriority();
	cfFile.Write(&dValue, sizeof(double) );

	dValue = m_QuestionList.GetCostPriority();
	cfFile.Write(&dValue, sizeof(double) );
	
	dValue = m_QuestionList.GetTechPriority();
	cfFile.Write(&dValue, sizeof(double) );

	// Clear the modified flag
	m_QuestionList.ClearModified();

	SetTitleBar();
}

/////////////////////////////////////////////////////////////////////////////
//	When saving as a text file, we only save the summary results.
void CSERIMDlg::SaveTextFile(LPCSTR pszFilename)
{
	// Recalculate the equations
	m_QuestionList.CalculateAll();

	FILE*	fpOut = fopen(pszFilename, "wt");

	if (fpOut != NULL)
	{
		// Save the equation results
		for (UINT i = 0; i < NUMEQUATIONS; i++)
		{
			// Get the equation text
			CString strLine;
			strLine = m_QuestionList.GetEquationText( (EquationType) i);
			
			// Append the equation value.
			double dValue;
			dValue = 100.0 * m_QuestionList.GetResult( (EquationType) i);
			fprintf(fpOut, "%s = %.1f%%\n", strLine, dValue);
		}

		fclose(fpOut);
	}
}

/////////////////////////////////////////////////////////////////////////////
void CSERIMDlg::SaveHTMLFile(LPCSTR pszFilename)
{
	// Recalculate the equations
	m_QuestionList.CalculateAll();

	// Load the HTML template from the resource file
	HRSRC resHtml = FindResource(	AfxGetResourceHandle(),
					MAKEINTRESOURCE(IDR_HTML1),
					RT_HTML
					);

	if (resHtml == NULL) return;	// FATAL ERROR EXIT

	// Found the HTML resource. This is the HTML template.
	// Lock and Load
	HGLOBAL hHtml = LoadResource(AfxGetResourceHandle(), resHtml);
	DWORD	dSize = SizeofResource(AfxGetResourceHandle(), resHtml);
	LPVOID	lpHtml = LockResource(hHtml);

	// Now make it into a string that can be edited.
	TCHAR*	pszHTML;
	pszHTML = new TCHAR[dSize + 1];	
	if (pszHTML == NULL) return;	// FATAL ERROR EXIT

	// Copy the HTML resource into the string, where it will be edited.
	TCHAR*	pszSRC = (TCHAR*) lpHtml;
	TCHAR*	pszDest = pszHTML;
	for (DWORD i = 0; i < dSize; i++)
	{
		*pszDest = *pszSRC;
		pszDest++;
		pszSRC++;
	}

	// NULL terminate the string, then discard the temp storage.
	*pszDest = '\0';
	CString szHTML = pszHTML;
	delete pszHTML;
	
	// Search and Replace the HTML to insert the results
	ReplaceHTML(&szHTML);

	// Save the file
	CFile	cfFile(pszFilename, CFile::modeCreate | CFile::modeWrite);
	cfFile.Write( (LPVOID) ((LPCSTR) szHTML), szHTML.GetLength() );

}

/////////////////////////////////////////////////////////////////////////////
void CSERIMDlg::ReadFile(LPCSTR pszFilename)
{
	CFile	cfFile(pszFilename, CFile::modeRead);

	// Read the questions
	for (UINT i = 0; i < NUMQUESTIONS; i++)
	{
		int iValue;
		cfFile.Read(&iValue, sizeof(int) );
		m_QuestionList.GetQuestion(i)->SetAnswerOrdinal(iValue);
	}

	// Read the weightings
	double	dValue;
	cfFile.Read(&dValue, sizeof(double) );
	m_QuestionList.SetSchedPriority(dValue);

	cfFile.Read(&dValue, sizeof(double) );
	m_QuestionList.SetCostPriority(dValue);

	cfFile.Read(&dValue, sizeof(double) );
	m_QuestionList.SetTechPriority(dValue);

	// Set the UI
	CheckRadioButton(IDC_RADIO_ORG, IDC_RADIO_PERSON, IDC_RADIO_ORG);
	SetCategory(C_ORGANIZATION);

	// Clear the modified flag
	m_QuestionList.ClearModified();
	
	SetTitleBar();
	UpdateSummaryDlg();
	UpdateWeightDisplay();
}

/////////////////////////////////////////////////////////////////////////////
void CSERIMDlg::SetTitleBar()
{
	CString	strTitle;

	strTitle.LoadString(IDS_TITLEBAR);
	strTitle += m_strName;
	AfxGetMainWnd()->SetWindowText(strTitle);
}



/////////////////////////////////////////////////////////////////////////////
void CSERIMDlg::UpdateWeightDisplay()
{
	m_strPriority.Format(IDS_PRISTRING, 
						m_QuestionList.GetCostPriority() * 100.0,
						m_QuestionList.GetTechPriority() * 100.0,
						m_QuestionList.GetSchedPriority() * 100.0);

	UpdateData(FALSE);
}


/////////////////////////////////////////////////////////////////////////////
//	Given a CString with an HTML template, it replaces the key tags
//	with the SERIM results.
//	Used as part of the Save to HMTL menu command.
void CSERIMDlg::ReplaceHTML(CString *szHTML)
{
	struct	ReplaceDataType {
		TCHAR*			szSearchFor;
		EquationType	eType;
	};

	// Template strings in the HTMP template, and their corresponding equations
	static struct ReplaceDataType ReplaceData[] = {
		_T("&lt;PA__&gt;"), PA,
		_T("&lt;PA1_&gt;"), PA1,
		_T("&lt;PA2_&gt;"), PA2,
		_T("&lt;PA3_&gt;"), PA3,
		_T("&lt;PA4_&gt;"), PA4,
		_T("&lt;PA5_&gt;"), PA5,
		_T("&lt;PA6_&gt;"), PA6,
		_T("&lt;PA7_&gt;"), PA7,
		_T("&lt;PA8_&gt;"), PA8,
		_T("&lt;PA9_&gt;"), PA9,
		_T("&lt;PA10&gt;"), PA10,
		_T("&lt;PA11&gt;"), PA11,
		_T("&lt;PA12&gt;"), PA12,
		_T("&lt;PA13&gt;"), PA13,
		_T("&lt;PB__&gt;"), PB,
		_T("&lt;PC__&gt;"), PC,
		_T("&lt;PD__&gt;"), PD,
		_T("&lt;PE__&gt;"), PE,
		_T("&lt;PF__&gt;"), PF,
		_T("&lt;PG__&gt;"), PG,
		_T("&lt;PH__&gt;"), PH,
		_T("&lt;PI__&gt;"), PI,
		_T("&lt;PJ__&gt;"), PJ,
		_T("&lt;PK__&gt;"), PK,
		_T("&lt;PL__&gt;"), PL,
		_T("&lt;PM__&gt;"), PM,
		_T("&lt;PN__&gt;"), PN,
		_T("&lt;PO__&gt;"), PO
	};

#define NUMREPLACESTRINGS (sizeof(ReplaceData) / sizeof(ReplaceDataType))
	
	// FOR each equation DO a Search and Replace
	CString szSearchFor;
	CString szTemp;
	int iIndex = 0;
	for (int i = 0; i < NUMREPLACESTRINGS; i++)
	{
		// Find the template string to replace.
		szSearchFor = ReplaceData[i].szSearchFor;
		iIndex = szHTML->Find(szSearchFor);
		if (iIndex < 0) continue;	// Skip if not found

		// Now get the value for this equation.
		double dValue = 100.0 * m_QuestionList.GetResult(ReplaceData[i].eType);
		szTemp.Format("%5.1f%%", dValue);

		// Delete the template text
		szHTML->Delete(iIndex, szSearchFor.GetLength() );

		// Insert the result text
		szHTML->Insert(iIndex, szTemp);
	}
	// END FOR

	// Now search and replace the Schedule weighting
	szSearchFor = _T("&lt;DS__&gt;");
	iIndex = szHTML->Find(szSearchFor);
	if (iIndex >=0) 	// Skip if not found
	{
		// Now get the value for this weight.
		double dValue = 100.0 * m_QuestionList.GetSchedPriority();
		szTemp.Format("%5.1f%%", dValue);

		// Delete the template text
		szHTML->Delete(iIndex, szSearchFor.GetLength() );

		// Insert the result text
		szHTML->Insert(iIndex, szTemp);
	}

	// Now search and replace the Cost weighting
	szSearchFor = _T("&lt;DC__&gt;");
	iIndex = szHTML->Find(szSearchFor);
	if (iIndex >=0) 	// Skip if not found
	{
		// Now get the value for this weight.
		double dValue = 100.0 * m_QuestionList.GetCostPriority();
		szTemp.Format("%5.1f%%", dValue);

		// Delete the template text
		szHTML->Delete(iIndex, szSearchFor.GetLength() );

		// Insert the result text
		szHTML->Insert(iIndex, szTemp);
	}

	// Now search and replace the Technical weighting
	szSearchFor = _T("&lt;DT__&gt;");
	iIndex = szHTML->Find(szSearchFor);
	if (iIndex >=0) 	// Skip if not found
	{
		// Now get the value for this weight.
		double dValue = 100.0 * m_QuestionList.GetTechPriority();
		szTemp.Format("%5.1f%%", dValue);

		// Delete the template text
		szHTML->Delete(iIndex, szSearchFor.GetLength() );

		// Insert the result text
		szHTML->Insert(iIndex, szTemp);
	}

	// Now search and replace the Filename
	szSearchFor = _T("&lt;FILENAME&gt;");
	iIndex = szHTML->Find(szSearchFor);
	if (iIndex >=0) 	// Skip if not found
	{
		// Delete the template text
		szHTML->Delete(iIndex, szSearchFor.GetLength() );

		// Insert the filename text
		szHTML->Insert(iIndex, m_strName);
	}

}

/////////////////////////////////////////////////////////////////////////////
//	Checks to see if the current file has been saved.
//	This checks the Modified flag of the CQuestionList object,
//	which sets when any setting or question has been modified, and
//	is cleared only when the file is saved.
//
//	If the file has not been saved, the user is prompted to continue.
//
//	RETURNS:	TRUE if the file has been saved, or if the user has
//				chosen to continue anyway.
//				FALSE if the user has chosen to abort the current operation.
//
BOOL CSERIMDlg::IsFileSaved()
{
	BOOL	bOK = TRUE;

	// Was the data modified?
	if (m_QuestionList.IsModified()) 
	{
		// Questions were modified. Prompt user to confirm action.
		CString szPrompt;
		szPrompt.LoadString(IDS_PROMPTACTION);
		int iResult = AfxMessageBox(szPrompt, MB_YESNO | MB_ICONEXCLAMATION);
		bOK = (iResult == IDYES) ? TRUE : FALSE;
	} 
	else 
	{
		// Nothing was modified. It's OK to continue.
		bOK = TRUE;
	}

	return bOK;
}
