/////////////////////////////////////////////////////////////////////////////
// SERIMDlg.h : header file
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_SERIMDLG_H__02E5F4DA_6923_4E60_BAF2_0C0CBD42852E__INCLUDED_)
#define AFX_SERIMDLG_H__02E5F4DA_6923_4E60_BAF2_0C0CBD42852E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "questionlist.h"
#include "dlgsummary.h"

/////////////////////////////////////////////////////////////////////////////
// CSERIMDlg dialog

class CSERIMDlg : public CDialog
{
// Construction
public:
	CSERIMDlg(CWnd* pParent = NULL);	// standard constructor
	void	SetDefaultFilename(LPCSTR pszFilename) { m_strFilename = pszFilename; m_strName = pszFilename;};

// Dialog Data
	//{{AFX_DATA(CSERIMDlg)
	enum { IDD = IDD_SERIM_DIALOG };
	CComboBox	m_ListBox;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSERIMDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	BOOL	IsFileSaved();
	void	ReplaceHTML(CString* szHTML);
	void	SaveHTMLFile(LPCSTR pszFilename);
	void	UpdateWeightDisplay();
	void	SaveTextFile(LPCSTR pszFilename);
	void	SetTitleBar();
	void	ReadFile(LPCSTR pszFilename);
	void	SaveSRMFile(LPCSTR pszFilename);
	void	UpdateSummaryDlg();
	void	MSG_AfterInit(WPARAM wParam = 0, LPARAM lParam = 0);
	void	MSG_SummaryClosed(WPARAM wParam = 0, LPARAM lParam = 0);

	void	SetCategory(UINT iCategory);
	void	OnRadioResponse(UINT nID);
	HICON	m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CSERIMDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnRadioOrg();
	afx_msg void OnRadioEstimate();
	afx_msg void OnRadioMonitor();
	afx_msg void OnRadioDevelop();
	afx_msg void OnRadioTools();
	afx_msg void OnRadioCulture();
	afx_msg void OnRadioUsability();
	afx_msg void OnRadioCorrect();
	afx_msg void OnRadioReliable();
	afx_msg void OnRadioPerson();
	afx_msg void OnSelchangeCombo1();
	afx_msg void OnDestroy();
	afx_msg void OnClose();
	afx_msg void OnAbout();
	afx_msg void OnNew();
	afx_msg void OnOpen();
	afx_msg void OnSave();
	afx_msg void OnSaveas();
	afx_msg void OnExit();
	afx_msg void OnPriority();
	afx_msg void OnSummary();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	CString	m_strCatSuccess;
	CString	m_strPriority;
	CString			m_strName;
	CString			m_strFilename;
	UINT			m_uCurrentCategory;
	CQuestionList	m_QuestionList;
	CQuestion*		m_UIQuestionList[12];
	CDlgSummary*	m_pDlgSummary;

	void	UpdateCategoryStats();
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SERIMDLG_H__02E5F4DA_6923_4E60_BAF2_0C0CBD42852E__INCLUDED_)





















