//////////////////////////////////////////////////////////////////////
// Questionlist.h: interface for the CQuestionList class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PROJECT_H__9BF721E7_965C_49DB_B878_11CCE7FB708F__INCLUDED_)
#define AFX_PROJECT_H__9BF721E7_965C_49DB_B878_11CCE7FB708F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
//////////////////////////////////////////////////////////////////////
#include "question.h"

#define NUMQUESTIONS	81
#define NUMEQUATIONS	28

enum EquationType { PA = 0,				/* Overall Risk Equation */
					PA1, PA2, PA3,		/* Technical, Cost, and Schedule Equations */
					PA4, PA5, PA6, PA7, PA8, PA9, PA10, PA11, PA12, PA13, /* Ten Category Equations */
					PB, PC, PD, PE, PF, PG,		/* Six Phase Equations */
					PH, PI, PJ, PK, PL, PM,		/* Six Activity Equations */
					PN, PO};			/* Process and Product Equations */


//////////////////////////////////////////////////////////////////////
class CQuestionList
{
public:
	void ClearModified();
	BOOL		IsModified();
	void		ClearAll();
	EquationType GetEquationType(UINT uCategory);
	LPCSTR		GetEquationText(EquationType eType);
	
	void		CalculateAll();
	double		CalculateTotal();
	double		CalculateSummary(EquationType eqType);
	double		Calculate(EquationType eqType);

	CQuestion*	GetQuestion(UINT iNum);
	UINT		GetNumQuestions() { return m_iNumQuestions; };
	double		GetResult(EquationType eqType);

	void		SetCostPriority(double dPriority) { m_dCostPriority = dPriority; m_bmodified = TRUE; };
	void		SetTechPriority(double dPriority) { m_dTechPriority = dPriority; m_bmodified = TRUE; };
	void		SetSchedPriority(double dPriority) { m_dSchedPriority = dPriority; m_bmodified = TRUE; };

	double		GetCostPriority() { return m_dCostPriority; };
	double		GetTechPriority() { return m_dTechPriority; };
	double		GetSchedPriority() { return m_dSchedPriority; };

	CQuestionList();
	virtual ~CQuestionList();

protected:
	CQuestion*	m_QuestionList[NUMQUESTIONS];

private:
	BOOL	m_bmodified;
	UINT	m_iNumQuestions;
	double	m_dTechPriority;
	double	m_dCostPriority;
	double	m_dSchedPriority;
};

#endif // !defined(AFX_PROJECT_H__9BF721E7_965C_49DB_B878_11CCE7FB708F__INCLUDED_)
